/**
* Script: button.js
* Written by: Radnen
* Updated: 11/11/2010
**/

function Button(parent, x, y, img, imgOv, imgDn)
{
	this.inherit = Control;
	
	var w = 0, h = 0;
	var down = false;
	var _enabled = true;
	var use_windows = false;
	
	this.text = "";
	if (typeof img == "string") {
		this.text = img;
		w = System.textFont.getStringWidth(img);
		h = System.textFont.getHeight();
		use_windows = true;
	}
	else { w = img.width; h = img.height; }
	
	this.inherit(parent, x, y, w, h);
	
	this.onClick = function() {};
	this.highlight = false;
	this.img = img;
	this.imgOv = imgOv;
	this.imgDn = imgDn;
	this.rightAnchor = false;
	this.cursorInside = false;
	this.mask = Colors.white;
	this.checked = false;
	this.canCheck = false;
	this.textOnly = false;
		
	this.__defineGetter__("enabled", function() { return _enabled;});
	this.__defineSetter__("enabled", function(n) {
		_enabled = n;
		if (n) this.mask = Colors.white;
		else this.mask = Colors.darkGray;
	});
	
	this.draw = function() {
		if (this.rightAnchor) this.x = this.parent.x + this.parent.w + this.xx;
		else this.x = this.parent.x + this.xx;
		
		this.y = this.parent.y + this.yy;
		
		if (this.checked && this.highlight && _enabled)
			System.selected.drawWindow(this.x, this.y, this.w, this.h);
		
		if (this.entered && this.highlight && !this.checked && _enabled)
			System.highlight.drawWindow(this.x, this.y, this.w, this.h);
		
		if (down) {
			if (use_windows) { if (!this.textOnly) System.btndn.drawWindow(this.x, this.y, this.w, this.h); }
			else {
				if (this.imgDn != undefined)
					this.imgDn.blitMask(this.x, this.y, this.mask);
				else this.img.blitMask(this.x, this.y, this.mask);
			}
		} else {
			if (use_windows) {
				if (!this.textOnly) {
					if (this.entered) System.btnov.drawWindow(this.x, this.y, this.w, this.h);
					else System.btnup.drawWindow(this.x, this.y, this.w, this.h);
				}
			} else if (this.entered) {
				if (this.imgOv != undefined)
					this.imgOv.blitMask(this.x, this.y, this.mask);
				else this.img.blitMask(this.x, this.y, this.mask);
			}
			else this.img.blitMask(this.x, this.y, this.mask);
		}
		
		if (use_windows) System.drawText(this.x, this.y, this.text, this.mask);
	}
	
	this.update = function() {
		if (this.enabled) this.updateMouse();
		
		if (this.parent.focusedControl == this) {
			down = (Cursor.onLeftHold() && _enabled && this.entered);
		}
	}
		
	this.onMouseUp.add(function() {
		if (_enabled) {
			if (this.canCheck) this.checked = !this.checked;
			down = false;
		}
	});
}